ORCA/M Asm65816 2.1.0

0001 0000              ****************************************************************
0002 0000              ***                                                          ***
0003 0000              ***                        Setup                             ***
0004 0000              ***                                                          ***
0005 0000              ***                                                          ***
0006 0000              ***  This is the master file for loading ROM patches.        ***
0007 0000              ***  This small file looks at the ROM version and            ***
0008 0000              ***  decides which patch file to load and execute.           ***
0009 0000              ***                                                          ***
0010 0000              ****************************************************************
0011 0000
0012 0000
0013 0000              ****************************************************************
0014 0000              ***                                                          ***
0015 0000              ***                       Version 3.0                        ***
0016 0000              ***                                                          ***
0017 0000              ***                     March 12, 1989                       ***
0018 0000              ***                                                          ***
0019 0000              ***                                                          ***
0020 0000              *** For version 2.0 or greater of the ROM.  This is          ***
0021 0000              *** different from earlier versions in that the patches      ***
0022 0000              *** are in different files and this file only loads them.    ***
0023 0000              ***                                                          ***
0024 0000              *** 29 Feb 88       Steven Glass                             ***
0025 0000              ***                                                          ***
0026 0000              *** Added code to get and dispose of handles so that enough  ***
0027 0000              *** master handles are made early.                           ***
0028 0000              ***                                                          ***
0029 0000              ***                                                          ***
0030 0000              *** 02 Dec 88       Steven Glass                             ***
0031 0000              ***                                                          ***
0032 0000              *** Zeroed DefaultTPT before calling SetDefaultTPT.          ***
0033 0000              ***                                                          ***
0034 0000              ***                                                          ***
0035 0000              ***                                                          ***
0036 0000              *** 06 Feb 89       Mensch                                   ***
0037 0000              ***                                                          ***
0038 0000              *** Added test for system memory size. If the memorysize     ***
0039 0000              *** of the system if <512K then we use patch file A          ***
0040 0000              *** else we use patch file B                                 ***
0041 0000              ***                                                          ***
0042 0000              *** 24 Feb 89       Steven Glass                             ***
0043 0000              ***                                                          ***
0044 0000              *** The SmallMemThreshold value was 8 but the compare was    ***
0045 0000              *** for strictly less than.  I changed it to 9.              ***
0046 0000              ***                                                          ***
0047 0000              ***                                                          ***
0048 0000              *** 12 Mar 89       Steven Glass                             ***
0049 0000              ***                                                          ***
0050 0000              *** Asked GQuit to remove from memory.  Got different ID     ***
0051 0000              *** for files that I load.  Removed code that looks for      ***
0052 0000              *** TS2A and TS2B.  Only TS2 is used again.  Small mem       ***
0053 0000              *** smarts are in TS2.                                       ***
0054 0000              ***                                                          ***
0055 0000              *** 30 Nov 89       Harry Yee                                ***
0056 0000              ***                                                          ***
0057 0000              *** Put in fix for call GetNewID. It needs to be done here   ***
0058 0000              *** because the patch file is not loaded soon enough.        ***
0059 0000              *** BRC #53470. The first ID reserved is always lost (this   ***
0060 0000              *** only happens on Tenspeed ROMs). So what we do is just    ***
0061 0000              *** call GetNewID with any main ID.                          ***
0062 0000              ***                                                          ***
0063 0000              ****************************************************************
0064 0000              *
0065 0000              * BEGIN 6.0
0066 0000              *
0067 0000              * 24-Sep-90         Dave Lyons
0068 0000              *
0069 0000              * Added a PurgeAll($A000) and CompactMem after calling the
0070 0000              * TSx patch.
0071 0000              *
0072 0000              * 27-Mar-91         Dave Lyons
0073 0000              *
0074 0000              * Added a real error message for failure to load the TSx
0075 0000              * file (it was just a BRK $FF before).
0076 0000              *
0077 0000              * 17-Sep-91         Dave Lyons
0078 0000              *
0079 0000              * Rolling patches common to both TS2 and TS3 into Tool.Setup.
0080 0000              * Strategy:  We call SetTSPtr on commonly-patched tool sets,
0081 0000              * and then we call TSx, which is guaranteed to call SetTSPtr
0082 0000              * again on all the tool sets we patched.  The FPTs contained
0083 0000              * in Tool.Setup are only needed temporarily.  When we're done,
0084 0000              * our main segment goes away (it loads in high memory).
0085 0000              *
0086 0000              * 27-Jan-92         Dave Lyons
0087 0000              *
0088 0000              * Added patch to $E10094 vector for both ROM 1 and ROM 3.
0089 0000              * The patch sets the bank register to $00 around the call,
0090 0000              * because we never documented that you had to do that, and
0091 0000              * 3rd-party software is trashing memory when the firmware
0092 0000              * winds up storing to RAM instead of softswitches. -- The
0093 0000              * patch code is in Patch3:Misc.tools.pch.
0094 0000              *
0095 0000              ****************************************************************
0096 0000              *
0097 0000              * BEGIN 6.0.1
0098 0000              *
0099 0000              * 20-Aug-92         Dave Lyons
0100 0000              *
0101 0000              * Added entries for AlertMessage and DoSysPrefs.
0102 0000              *
0103 0000              ****************************************************************
0104 0000
0105 0000              ****************************************************************
0106 0000              ***                                                          ***
0107 0000              ***                                                          ***
0108 0000              ***            Copyright (C) Apple Computer, Inc.            ***
0109 0000              ***            1985-1991                                     ***
0110 0000              ***            All Rights Reserved                           ***
0111 0000              ***                                                          ***
0112 0000              ***                                                          ***
0113 0000              ****************************************************************
0114 0000
0115 0000                       eject 
0116 0000
0117 0000              ; This ROM patch file is an INIT file.  An init file is a file
0118 0000              ; that GS/OS loads and runs before it runs any applications.
0119 0000              ; This particular file is called Tool.Setup.  GS/OS loads and
0120 0000              ; runs this file before any other init files.  If GS/OS cannot
0121 0000              ; find this init file on the disk, it will not complete the
0122 0000              ; boot process.
0123 0000
0124 0000
0125 0000                       include 'all.macros' 
0126 0000                       include ':::sys.equs.asm' 
0127 0000                       include ':::desk:Desk.Equates.asm' 
0128 0000
0129 0000              PendingSysBeep2 equ   $E1167E
0130 0000
0131 0000              Setup    PROC EXPORT 
0132 0000                       import AddTBNotifyProc 
0133 0000                       import AddTBRequestHandler 
0134 0000                       import DoCommonPatches 
0135 0000
0136 0000              ;----------------------------------------------------
0137 0000              ;
0138 0000              ; Before anything else call this routine of Fern's
0139 0000              ; to try and reinitialize certain Apple Desk Top Bus
0140 0000              ; devices since they don't seem to power up correctly.
0141 0000              ;
0142 0000              ;----------------------------------------------------
0143 0000
0144 0000              *** 27-Jan-92 DAL -- force Bank to 0
0145 0000 8B                    phb   
0146 0001 F4 00 00              pea   0
0147 0004 AB                    plb   
0148 0005 AB                    plb   
0149 0006              *** end 27-Jan-92
0150 0006 E2 30                 sep   #$30
0151 0008                       longa off
0152 0008                       longi off
0153 0008              ;;;	lda	>StateReg
0154 0008 AD 68 C0              lda   StateReg                 ;abs addr, 27-Jan-92 DAL
0155 000B 48                    pha   
0156 000C A9 0C                 lda   #$0C
0157 000E              ;;;	sta	>StateReg
0158 000E 8D 68 C0              sta   StateReg                 ;abs addr, 27-Jan-92 DAL
0159 0011 38                    sec   
0160 0012 22 94 00 E1           jsl   $E10094                  ; Fern's vector
0161 0016 68                    pla   
0162 0017              ;;;	sta	>StateReg
0163 0017 8D 68 C0              sta   StateReg                 ;abs addr, 27-Jan-92 DAL
0164 001A C2 30                 rep   #$30
0165 001C                       longa on
0166 001C                       longi on
0167 001C              ;;;	plb		;27-Jan-92 DAL -- restore bank, but optimize out
0168 001C              ;;;
0169 001C              ;;;	phb		; save data bank register
0170 001C 4B                    phk   
0171 001D AB                    plb   
0172 001E
0173 001E              ;-----------------------------------------------------
0174 001E              ;
0175 001E              ; Look at the version number of QuickDraw to decide
0176 001E              ; what ROM this is.  Based on this value load and
0177 001E              ; execute the appropriate file.
0178 001E              ;
0179 001E              ;----------------------------------------------------
0180 001E
0181 001E 48                    pha   
0182 001F A2 04 04 22           _QDVersion 
0183 0026 68                    pla   
0184 0027 29 00 7F              and   #$7F00
0185 002A
0186 002A C9 00 01              cmp   #$0100                   ; is this rom1?
0187 002D F0 20                 beq   ItsOne
0188 002F
0189 002F              ;
0190 002F              ; Fix for GetNewID which always loses the first ID reserved, thus making it 
0191 002F              ; possible for two programs to get the same ID. BRC #53470.
0192 002F              ;
0193 002F 48                    pha                            ; space for result
0194 0030 F4 00 50              pea   $5000                    ; any type is fine
0195 0033 A2 03 20 22           _GetNewID 
0196 003A 68                    pla   
0197 003B
0198 003B 48                    pha   
0199 003C A2 01 04 22           _TLVersion 
0200 0043 68                    pla   
0201 0044 29 00 7F              and   #$7F00
0202 0047
0203 0047 C9 00 04              cmp   #$0400                   ; if >= ROM 4 then don't patch.
0204 004A 90 03                 bcc   ItsOne
0205 004C 82 9F 00              brl   SkipPatch
0206 004F
0207 004F EB           ItsOne   xba                            ; take this value and make
0208 0050 18                    clc                            ; it into an ascci char
0209 0051 69 30 00              adc   #'0'
0210 0054 E2 30                 sep   #$30                     ; only put one byte into patch
0211 0056 8D B0 01              sta   LastDigit                ; put char at end of path name
0212 0059 8D 44 01              sta   ErrorMsgDigit
0213 005C C2 30                 rep   #$30                     ; back to 16 bit mode
0214 005E
0215 005E
0216 005E              ;-----------------------------------------------------------
0217 005E              ;
0218 005E              ; Get 200 handles now so that the launcher and most other
0219 005E              ; apps will not run out.  
0220 005E              ;
0221 005E              ; This code was added on 29 Feb 88 to solve problem of 
0222 005E              ; the launcher getting out of memory error when there was
0223 005E              ; still memory available.  The memory was all special and
0224 005E              ; no new handles could be made.
0225 005E              ;
0226 005E              ;
0227 005E              ;----------------------------------------------------
0228 005E              SpecialIDForHandles equ   $4F01
0229 005E
0230 005E A0 C8 00              ldy   #200
0231 0061 5A           @1       phy   
0232 0062 48                    pha                            ; space for handle
0233 0063 48                    pha   
0234 0064 F4 00 00 F4           PushLong #0                    ; size 0
0235 006A F4 01 4F              PushWord #SpecialIDForHandles 
0236 006D F4 00 00              PushWord #0 
0237 0070 48                    pha   
0238 0071 48                    pha   
0239 0072 A2 02 09 22           _NewHandle 
0240 0079 FA                    plx   
0241 007A FA                    plx   
0242 007B 90 03                 bcc   @dontDie
0243 007D 82 96 00              brl   Die
0244 0080 7A           @dontDie ply   
0245 0081 88                    dey   
0246 0082 10 DD                 bpl   @1
0247 0084
0248 0084 F4 01 4F              PushWord #SpecialIDForHandles 
0249 0087 A2 02 11 22           _DisposeAll 
0250 008E
0251 008E 20 B1 01              jsr   DoCommonPatches          ;17-Sep-91 DAL
0252 0091
0253 0091 48                    pha                            ; get My userID
0254 0092 F4 00 A0              PushWord #$A000 
0255 0095 A2 03 20 22           _GetNewID 
0256 009C 68                    pla   
0257 009D 8D 95 01              sta   patchID
0258 00A0
0259 00A0 DA                    phx                            ; space for zp segment size
0260 00A1 DA                    phx                            ; space for zp segment starting address
0261 00A2 DA                    phx                            ; space for starting address
0262 00A3 DA                    phx   
0263 00A4 DA                    phx                            ; space for userid
0264 00A5 48                    pha                            ; Push the Tools userID
0265 00A6 F4 02 00 F4           PushLong #PatchName 
0266 00AC F4 FF FF              PushWord #$ffff                ; Not in special memory
0267 00AF A2 11 09 22           _InitialLoad 
0268 00B6 B0 5E                 bcs   Die
0269 00B8
0270 00B8 7A                    ply                            ; don't need user id
0271 00B9 FA                    plx                            ; need starting addr in x,a
0272 00BA 68                    pla                            ; (x has low, a has high)
0273 00BB 7A                    ply                            ; don't need zp adr
0274 00BC 7A                    ply                            ; don't need zp seg size.
0275 00BD
0276 00BD 8E C8 00              stx   SelfModCall+1
0277 00C0 E2 20                 sep   #$20
0278 00C2 8D CA 00              sta   SelfModCall+3
0279 00C5 C2 20                 rep   #$20
0280 00C7
0281 00C7 22 77 77 77  SelfModCall jsl   $777777
0282 00CB
0283 00CB F4 00 A0              pea   $A000
0284 00CE A2 02 13 22           _PurgeAll 
0285 00D5 A2 02 1F 22           _CompactMem 
0286 00DC
0287 00DC              ;-------------------------------------------------
0288 00DC              ;
0289 00DC              ; Call SetDefaultTPT to make the current TPT
0290 00DC              ; the default one.
0291 00DC              ;
0292 00DC              ; Note:  This may return an error but that's okay
0293 00DC              ; since stack is not hurt.
0294 00DC              ;
0295 00DC              ; Zero the DefaultTPT since this is the first time 
0296 00DC              ; it is referenced.
0297 00DC              ;
0298 00DC              ;----------------------------------------------------
0299 00DC A9 00 00              lda   #0
0300 00DF 8F 88 01 E1           sta   >DefaultTPTPtr
0301 00E3 8F 8A 01 E1           sta   >DefaultTPTPtr+2
0302 00E7 A2 01 16 22           _SetDefaultTPT 
0303 00EE
0304 00EE              SkipPatch  
0305 00EE 22 72 08 02           jsl   AddTBNotifyProc
0306 00F2 22 D6 08 02           jsl   AddTBRequestHandler
0307 00F6
0308 00F6 AB                    plb                            ; restore dbr
0309 00F7
0310 00F7              ;
0311 00F7              ; Now unload this segment of code be sure to do a jump instead
0312 00F7              ; of a jsl this way we don't have to worry about whether this code
0313 00F7              ; disappears...
0314 00F7              ;
0315 00F7 48                    pha                            ; DAL 18-Sep-90
0316 00F8 A2 02 02 22           _MMStartUp                     ; DAL 18-Sep-90
0317 00FF FA                    plx                            ; DAL 18-Sep-90
0318 0100
0319 0100                       longa off
0320 0100 E2 20                 sep   #$20
0321 0102 68                    pla   
0322 0103 7A                    ply                            ; get the return address from the stack
0323 0104
0324 0104 DA                    phx   
0325 0105
0326 0105 F4 01 00              pea   $0001                    ; and our file num...
0327 0108 F4 01 00              pea   $0001                    ; even our segment number...
0328 010B 5A                    phy   
0329 010C 48                    pha                            ; put the return address back...
0330 010D                       longa On
0331 010D C2 20                 rep   #$20
0332 010F A2 11 0C              ldx   #$0C11                   ; and make the UnloadsegNumCall
0333 0112 5C 00 00 E1           jml   >$E10000                 ; and call the tool locator...
0334 0116
0335 0116
0336 0116 48           Die      pha   
0337 0117 F4 02 00 F4           pushlong #FailureMessage 
0338 011D A2 03 15 22           _SysFailMgr 
0339 0124 00 FF                 brk   $FF
0340 0126
0341 0126 6F           FailureMessage DC B:FailMsgEnd-FailureMessage
0342 0127 43 6F 75 6C           DC B:'Could not load setup file: TS*',13
0343 0146 50 6C 65 61           DC B:'Please use the Installer to set up your',13
0344 016E 62 6F 6F 74           DC B:'boot disk correctly for this GS',13,13
0345 018F 45 72 72 6F           DC B:'Error='
0346 0195              FailMsgEnd  
0347 0195              ErrorMsgDigit equ   FailureMessage+30
0348 0195
0349 0195 00 00        PatchID  DS W:1
0350 0197 19 2A 2F 53  PatchName DC C:'*/System/System.Setup/TS*'
0351 01B1              LastDigit equ   *-1
0352 01B1              MemLevel equ   LastDigit+1
0353 01B1
0354 01B1                       ENDP 
0355 01B1
0356 01B1
0357 01B1              ****************************************************************
0358 01B1              *
0359 01B1              * DoCommonPatches -- install patches common to ROM 1 and ROM 3
0360 01B1              *
0361 01B1              ****************************************************************
0362 01B1              DoCommonPatches proc 
0363 01B1                       import LocatorCallTable,MTCallTable,DeskCallTable 
0364 01B1                       import ToBramSetupPatch,oldToBramSetupCall  ;from Misc Tools
0365 01B1
0366 01B1              *** added 27-Jan-92 DAL
0367 01B1 08                    php   
0368 01B2 78                    sei   
0369 01B3 AF 95 00 E1           lda   >$e10094+1
0370 01B7 8F 25 1E 02           sta   >oldToBramSetupCall+1
0371 01BB AF 96 00 E1           lda   >$e10094+2
0372 01BF 8F 26 1E 02           sta   >oldToBramSetupCall+2
0373 01C3 A9 1E 02              lda   #ToBramSetupPatch>>8
0374 01C6 8F 96 00 E1           sta   >$e10094+2
0375 01CA A9 1E 1E              lda   #ToBramSetupPatch
0376 01CD 8F 95 00 E1           sta   >$e10094+1
0377 01D1 28                    plp   
0378 01D2              *** end 27-Jan-92
0379 01D2
0380 01D2 F4 01 00              pea   $0001                    ;special flag to patch TL on ROM 3
0381 01D5 F4 01 00              pea   $0001                    ;tool set = Tool Locator
0382 01D8 F4 02 00 F4           pushlong #LocatorCallTable 
0383 01DE A2 01 0A 22           _SetTSPtr 
0384 01E5
0385 01E5 F4 00 00              pea   $0000                    ;system tool
0386 01E8 F4 03 00              pea   $0003                    ;tool set = misc tools
0387 01EB F4 02 00 F4           pushlong #MTCallTable 
0388 01F1 A2 01 0A 22           _SetTSPtr 
0389 01F8
0390 01F8 F4 01 00              pea   $0001                    ;special flag to patch DM on ROM 3
0391 01FB F4 05 00              pea   $0005                    ;tool set = Desk Manager
0392 01FE F4 02 00 F4           pushlong #DeskCallTable 
0393 0204 A2 01 0A 22           _SetTSPtr 
0394 020B
0395 020B 60                    rts   
0396 020C
0397 020C                       EndP 
0398 020C
0399 020C              ****************************************************************
0400 020C              *
0401 020C              * Tool Locator call table -- patches common to ROM 1 and ROM 3
0402 020C              *
0403 020C              ****************************************************************
0404 020C              LocatorCallTable proc EXPORT 
0405 020C
0406 020C                       import AcceptRequests          ;17-Sep-90 DAL
0407 020C                       import SendRequest             ;17-Sep-90 DAL
0408 020C                       import GetMsgHandle            ;25-Sep-90 DAL
0409 020C                       import StartUpTools            ;17-Nov-90 DAL
0410 020C                       import ShutDownTools           ;17-Nov-90 DAL
0411 020C                       import LoadOneTool             ;17-Nov-90 DAL
0412 020C                       import LoadTools               ;17-Nov-90 DAL
0413 020C                       import UnloadOneTool           ;25-Nov-90 DAL
0414 020C
0415 020C              TheBeginning  
0416 020C 1D 00 00 00           DC L:(TheEnd-TheBeginning)/4   ; call count + 1
0417 0210
0418 0210 7F 02 02 00           DC L:TLBootInit-1              ; TLBootInit (0101)
0419 0214 00 00 00 00           DC L:0                         ; TLStartUp  (0201)
0420 0218 00 00 00 00           DC L:0                         ; TLShutDwon (0301)
0421 021C 00 00 00 00           DC L:0                         ; TLVersion  (0401)
0422 0220 00 00 00 00           DC L:0                         ; TLReset    (0501)
0423 0224 00 00 00 00           DC L:0                         ; TLStatus   (0601)
0424 0228 00 00 00 00           DC L:0                         ; NotImp     (0701)
0425 022C 00 00 00 00           DC L:0                         ; NotImp     (0801)
0426 0230 00 00 00 00           DC L:0                         ; GetTSPtr   (0901)
0427 0234 00 00 00 00           DC L:0                         ; SetTSPtr   (0A01)
0428 0238 00 00 00 00           DC L:0                         ; GetFuncPtr (0B01)
0429 023C 00 00 00 00           DC L:0                         ; GetWAP     (0C01)
0430 0240 00 00 00 00           DC L:0                         ; SetWAP     (0D01)
0431 0244 FD 18 02 00           DC L:LoadTools-1               ;                   0e01
0432 0248 34 1A 02 00           DC L:LoadOneTool-1             ;                   0f01
0433 024C 51 1A 02 00           DC L:UnloadOneTool-1           ;                   1001
0434 0250 00 00 00 00           DC L:0                         ; TLMountVolume     1101
0435 0254 00 00 00 00           DC L:0                         ; TLTextMountVolume 1201
0436 0258 00 00 00 00           DC L:0                         ; SaveTextState     1301
0437 025C 00 00 00 00           DC L:0                         ; RestoreTextState  1401
0438 0260 00 00 00 00           DC L:0                         ; MesasgeCenter     1501
0439 0264 00 00 00 00           DC L:0                         ; SetDefaultTPT     1601
0440 0268 00 00 00 00           DC L:0                         ; MessageByName     1701
0441 026C C8 10 02 00           DC L:StartupTools-1            ; StartUpTools      1801
0442 0270 1A 13 02 00           DC L:ShutDownTools-1           ; ShutDownTools     1901
0443 0274              *** New calls for 6.0
0444 0274 00 05 02 00           DC L:GetMsgHandle-1            ; 1A01  17-Sep-90 DAL
0445 0278 C0 05 02 00           DC L:AcceptRequests-1          ; 1B01  17-Sep-90 DAL
0446 027C 56 07 02 00           DC L:SendRequest-1             ; 1C01  17-Sep-90 DAL
0447 0280              TheEnd    
0448 0280
0449 0280 A9 00 00     TLBootInit lda   #0
0450 0283 18                    clc   
0451 0284 6B                    rtl   
0452 0285
0453 0285                       EndP 
0454 0285
0455 0285              ****************************************************************
0456 0285              *
0457 0285              * Misc Tools call table -- patches common to ROM 1 and ROM 3
0458 0285              *
0459 0285              ****************************************************************
0460 0285              MTCallTable proc 
0461 0285                       import UnPackBytes,ConvSeconds,SysBeep2,VersionString 
0462 0285                       import WaitUntil,StringToText,ShowBootInfo,ScanDevices 
0463 0285                       import AlertMessage,DoSysPrefs 
0464 0285
0465 0285              Here      
0466 0285 40 00 00 00           DC L:(TheEnd-Here)/4           ; num calls +1
0467 0289 84 03 02 00           DC L:MTInit-1                  ; PowerUp Initialization
0468 028D 00 00 00 00           DC L:0                         ; application startup
0469 0291 00 00 00 00           DC L:0                         ; application shutdown
0470 0295 00 00 00 00           DC L:0                         ; version number
0471 0299 00 00 00 00           DC L:0                         ; Misc. Tools Reset
0472 029D 00 00 00 00           DC L:0                         ; MTStatus
0473 02A1 00 00 00 00           DC L:0                         ; Reserved
0474 02A5 00 00 00 00           DC L:0                         ; Reserved
0475 02A9 00 00 00 00           DC L:0                         ; Write battery ram
0476 02AD 00 00 00 00           DC L:0                         ; Read battery ram
0477 02B1 00 00 00 00           DC L:0                         ; Write battery ram parameter
0478 02B5 00 00 00 00           DC L:0                         ; Read battery ram parameter
0479 02B9 00 00 00 00           DC L:0                         ; read clock w/ hex format
0480 02BD 00 00 00 00           DC L:0                         ; write clock w/ hex format
0481 02C1 00 00 00 00           DC L:0                         ; read clock w/ ascii format
0482 02C5 00 00 00 00           DC L:0                         ; set interrupt vector
0483 02C9 00 00 00 00           DC L:0                         ; get interrupt vector
0484 02CD 00 00 00 00           DC L:0                         ; insert procedure in Heartbeat chain
0485 02D1 00 00 00 00           DC L:0                         ; delete procedure from heartbeat chai
0486 02D5 00 00 00 00           DC L:0                         ; clear heartbeat chain
0487 02D9 00 00 00 00           DC L:0                         ; system death manager
0488 02DD 00 00 00 00           DC L:0
0489 02E1 00 00 00 00           DC L:0                         ; Read Mouse
0490 02E5 00 00 00 00           DC L:0                         ; initialize mouse
0491 02E9 00 00 00 00           DC L:0                         ; set mouse mode
0492 02ED 00 00 00 00           DC L:0                         ; home mouse position to min. clamp
0493 02F1 00 00 00 00           DC L:0                         ; clear mouse position to 0
0494 02F5 00 00 00 00           DC L:0                         ; set both X and Y clamps
0495 02F9 00 00 00 00           DC L:0                         ; get both X and Y clamps
0496 02FD 00 00 00 00           DC L:0                         ; set mouse position
0497 0301 00 00 00 00           DC L:0                         ; service mouse interrupt
0498 0305 00 00 00 00           DC L:0                         ; get ID tag
0499 0309 00 00 00 00           DC L:0                         ; delete ID tag
0500 030D 00 00 00 00           DC L:0                         ; get ID tag status
0501 0311 00 00 00 00           DC L:0                         ; enable interrupt source
0502 0315 00 00 00 00           DC L:0                         ; Firmware entry points
0503 0319 00 00 00 00           DC L:0                         ; get tick counter contents
0504 031D 00 00 00 00           DC L:0                         ; Pack bytes
0505 0321 29 1E 02 00           DC L:UnPackBytes-1             ; UnPack dem dere bytes
0506 0325 00 00 00 00           DC L:0                         ; This routine munges strings
0507 0329 00 00 00 00           DC L:0                         ; returns IRQ enble status
0508 032D 00 00 00 00           DC L:0                         ; set absolute device clamps
0509 0331 00 00 00 00           DC L:0                         ; get absolute device clamps
0510 0335 00 00 00 00           DC L:0                         ; 2C03 system beep
0511 0339
0512 0339 00 00 00 00           DC L:0                         ; 2D03 NewBasicInit ; added 07 sep 88
0513 033D
0514 033D 00 00 00 00           DC L:0                         ; 2E03 AddToQueue   ; added 10 sep 88
0515 0341 00 00 00 00           DC L:0                         ; 2F03 RemoveFromQueue ; added 10 sep 88
0516 0345 00 00 00 00           DC L:0                         ; 3003 SetInterruptState added 24 Nov 88
0517 0349 00 00 00 00           DC L:0                         ; 3103 GetInterruptState added 24 Nov 88
0518 034D 00 00 00 00           DC L:0                         ; 3203 GetIntStateRecSize added 24 Nov 88
0519 0351
0520 0351 00 00 00 00           DC L:0                         ; 3303 ReadMouse2 Added 13 Jan 89
0521 0355 00 00 00 00           DC L:0                         ; 3403 GetCodeResConverter added 13 Jan 89 {$3403}
0522 0359 00 00 00 00           DC L:0                         ; 3503 GetROMResource added 24 Jan 89 ($3503}
0523 035D 00 00 00 00           DC L:0                         ; 3603 ReleaseROMResource added 24 Jan 89 {$3603}
0524 0361              *** 5.0.3
0525 0361 95 1F 02 00           DC L:ConvSeconds-1             ; 3703 added 3/14/90
0526 0365              *** 6.0
0527 0365 3C 22 02 00           DC L:SysBeep2-1                ; 3808 added 17-Sep-90 DAL
0528 0369 F9 22 02 00           DC L:VersionString-1           ;3903 added 5-Dec-90 DAL
0529 036D 91 23 02 00           DC L:WaitUntil-1               ; 3A03 added 6-Jan-91 DAL
0530 0371 00 24 02 00           DC L:StringToText-1            ; 3B03 added 3-Mar-91 DAL
0531 0375 F5 2A 02 00           DC L:ShowBootInfo-1            ; 3C03 added 29-Mar-91 DAL
0532 0379 45 2A 02 00           DC L:ScanDevices-1             ; 3D03 added 29-Mar-91 DAL
0533 037D              *** 6.0.1
0534 037D 6C 2A 02 00           DC L:AlertMessage-1            ; 3E03 added 20-Aug-92 DAL
0535 0381 CA 2A 02 00           DC L:DoSysPrefs-1              ; 3F03 added 20-Aug-92 DAL
0536 0385              TheEnd    
0537 0385
0538 0385 A9 00 00     MTInit   lda   #0
0539 0388 8F 7E 16 E1           sta   >PendingSysBeep2
0540 038C 18                    clc   
0541 038D 6B                    rtl   
0542 038E
0543 038E                       EndP 
0544 038E
0545 038E              ****************************************************************
0546 038E              *
0547 038E              * Desk Manager call table -- patches common to ROM 1 and ROM 3
0548 038E              *
0549 038E              ****************************************************************
0550 038E              DeskCallTable proc 
0551 038E                       import ChooseCDA 
0552 038E                       import SystemClick,SystemEdit,SystemTask 
0553 038E                       import SystemEvent,CloseNDAbyWinPtr,CloseAllNDAs2 
0554 038E                       import FixAppleMenu2,RemoveNDA,GetDeskAccInfo 
0555 038E                       import CallDeskAcc,GetDeskGlobal 
0556 038E                       import MonKeyin 
0557 038E
0558 038E              TheBeginning  
0559 038E 26 00 00 00           DC L:(TheEnd-TheBeginning)/4   ; num calls + 1
0560 0392 25 04 02 00           DC L:DABootInit-1              ;                   ; 0105
0561 0396 00 00 00 00           DC L:0                         ;DAStartup-1        ; 0205 patched 4-Mar-91 DAL
0562 039A 00 00 00 00           DC L:0                         ;DAShutdown-1       ; 0305 patched 4-Mar-91 DAL
0563 039E 00 00 00 00           DC L:0                         ;DAVersion-1        ; 0405
0564 03A2 00 00 00 00           DC L:0                         ; DAReset-1         ; 0505
0565 03A6 00 00 00 00           DC L:0                         ; DAStatus-1        ; 0605
0566 03AA 00 00 00 00           DC L:0                         ; oEndCall0-1       ; 0705     reserved
0567 03AE 00 00 00 00           DC L:0                         ; oEndCall0-1       ; 0805     reserved
0568 03B2 00 00 00 00           DC L:0                         ; SaveScreen-1      ; 0905
0569 03B6 00 00 00 00           DC L:0                         ; RestScreen-1      ; 0A05
0570 03BA 00 00 00 00           DC L:0                         ; SaveAll-1         ; 0B05
0571 03BE 00 00 00 00           DC L:0                         ; RestAll-1         ; 0C05
0572 03C2 00 00 00 00           DC L:0                         ; oEndCall0-1       ; 0D05
0573 03C6 00 00 00 00           DC L:0                         ;InstallNDA-1       ; 0E05
0574 03CA 00 00 00 00           DC L:0                         ; instcda-1         ; 0F05
0575 03CE 00 00 00 00           DC L:0                         ; oEndCall0-1       ; 1005
0576 03D2 26 2F 02 00           DC L:ChooseCDA-1               ; 1105
0577 03D6 00 00 00 00           DC L:0                         ; oEndCall0-1       ; 1205
0578 03DA 00 00 00 00           DC L:0                         ; setdastrptr-1     ; 1305
0579 03DE 00 00 00 00           DC L:0                         ; getdastrptr-1     ; 1405
0580 03E2 00 00 00 00           DC L:0                         ;OpenNDAentry-1     ; 1505
0581 03E6 00 00 00 00           DC L:0                         ;CloseNDA-1         ; 1605
0582 03EA E1 3D 02 00           DC L:SystemClick-1             ; 1705
0583 03EE EA 3F 02 00           DC L:SystemEdit-1              ; 1805
0584 03F2 BF 3C 02 00           DC L:SystemTask-1              ; 1905
0585 03F6 B9 37 02 00           DC L:SystemEvent-1             ; 1A05
0586 03FA 00 00 00 00           DC L:0                         ;GetNumNDAs-1       ; 1B05
0587 03FE ED 3B 02 00           DC L:CloseNDAbyWinPtr-1        ; 1C05
0588 0402 13 3C 02 00           DC L:CloseAllNDAs2-1           ; 1D05
0589 0406 2F 40 02 00           DC L:FixAppleMenu2-1           ; 1E05
0590 040A 00 00 00 00           DC L:0                         ;AddToRunQ-1        ; 1F05
0591 040E 00 00 00 00           DC L:0                         ;RemoveFromRunQ-1   ; 2005
0592 0412 00 00 00 00           DC L:0                         ; RemoveCDA-1       ; 2105
0593 0416 B5 42 02 00           DC L:RemoveNDA-1               ; 2205
0594 041A 6A 43 02 00           DC L:GetDeskAccInfo-1          ; 2305  19-Sep-90 DAL
0595 041E 34 44 02 00           DC L:CallDeskAcc-1             ; 2405  19-Sep-90 DAL
0596 0422 F4 44 02 00           DC L:GetDeskGlobal-1           ; 2505  19-Feb-91 DAL
0597 0426              TheEnd    
0598 0426
0599 0426 A9 00 00     DABootInit lda   #0
0600 0429 8F BE 1D E0           sta   >RealDeskStatus
0601 042D
0602 042D A9 02 33              lda   #monkeyin
0603 0430 8F 8A 1D E0           sta   >KeyInput
0604 0434
0605 0434 18                    clc   
0606 0435 6B                    rtl   
0607 0436
0608 0436                       EndP 
0609 0436
0610 0436                       END   
